/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file           : main.c
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2025 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "cmsis_os.h"
#include "adc.h"
#include "dma.h"
#include "i2c.h"
#include "rtc.h"
#include "spi.h"
#include "tim.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "modbus.h"
#include "max31865.h"
#include "adc_mux_app.h"
#include "out_ctl.h"
#include "ws2812.h"
#include <math.h>
#include "24LCxx.h"
#include "telemetry.h"
#include "Baremetal_Tasks.h"
#include "hxb2_cmd_stm32.h"
#include "ads131m04.h"
#include "dac8554.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

// ���� Modbus Holding Register Map ����������������������������������������������������������
// �삩�룄 (float 2�썙�뱶�뵫)
#define MB_HREG_TEMP_T1        0   // 40000,40001
#define MB_HREG_TEMP_T2        2   // 40002,40003
#define MB_HREG_TEMP_T3        4   // 40004,40005

// ADC �떆�옉 (�삁: 40006 ~ ...)
#define MB_HREG_ADC_BASE       6

// RPM / Hz
#define MB_HREG_FAN_RPM       30   // 40030
#define MB_HREG_PUMP_HZ       31   // 40031

// �뵒吏��꽭 �엯�젰
#define MB_HREG_DI_TANK1      32
#define MB_HREG_DI_TANK2      33
#define MB_HREG_DI_TANK3      34
#define MB_HREG_DI_TANK4      35
#define MB_HREG_DI_CONTACT    36
#define MB_HREG_DI_SWITCH     37
#define MB_HREG_DI_DAC_RDY    38

#define MB_HREG_DI_SPARE1     39
#define MB_HREG_DI_SPARE2     40
#define MB_HREG_DI_SPARE3     41

// UART 猷⑦봽諛� �뀒�뒪�듃
#define MB_HREG_UART_RX       44   // �닔�떊媛�
#define MB_HREG_UART_TX       45   // �넚�떊紐낅졊

// ���� DAC �젣�뼱�슜 �젅吏��뒪�꽣 (�떒�쐞: 0.01 V) ������������������������������������������
// �삁) 150 �넂 1.50 V, 155 �넂 1.55 V
#define MB_HREG_DAC_CH_A      46   // DAC CH A
#define MB_HREG_DAC_CH_B      47   // DAC CH B
#define MB_HREG_DAC_CH_C      48   // DAC CH C
#define MB_HREG_DAC_CH_D      49   // DAC CH D

// PWM �젣�뼱�슜 ���뵫 �젅吏��뒪�꽣
// duty: 0~100  (�떒�쐞 1%)
// freq: 0~25000 (�떒�쐞 1Hz)
#define MB_HREG_FAN_PWM_DUTY   50   // ex) 80 �넂 80%
#define MB_HREG_FAN_PWM_FREQ   51   // ex) 20000 �넂 20 kHz

// WS2812 LED �깋�긽 �젣�뼱 (肄붾뱶 媛�)
// 0: OFF, 1: RED, 2: BLUE, 3: GREEN, 4: YELLOW, 5: CYAN, 6: MAGENTA, 7: WHITE ...
#define MB_HREG_LED1_COLOR    52   // LED1 �깋 肄붾뱶
#define MB_HREG_LED2_COLOR    53   // LED2 �깋 肄붾뱶

#define FAN_PULSES_PER_REV   2u   // 
#define FAN_RPM_PERIOD_MS    1000u // 珥덈떦
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
static uint8_t g_uart1_rx[2];
static volatile uint8_t g_uart1_rx_ready = 0;

volatile uint32_t g_fan_pulse_count = 0;
volatile uint32_t g_pump_pulse_count = 0;

volatile float PWM_FAN_RPM = 0.0f; // TIM1_CH1 �넂 RPM
volatile float TANK_ADD_PUMP_FREQ = 0.0f; // TIM5_CH3 �넂 Hz
Modbus_t modbus;
Max31865_t rtd1, rtd2, rtd3;
float g_t1 = 0, g_t2 = 0, g_t3 = 0;
static const float DAC_VREF = 5.0f;
static const int DAC_GAIN_X2 = 0;

volatile uint16_t DI_TANK1 = 0;
volatile uint16_t DI_TANK2 = 0;
volatile uint16_t DI_TANK3 = 0;
volatile uint16_t DI_TANK4 = 0;
volatile uint16_t DI_CONTACT = 0;
volatile uint16_t DI_SWITCH = 0;
volatile uint16_t DI_DAC_RDY = 0;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
void MX_FREERTOS_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void rtd_init_all(void)
{
	Max31865_init(&rtd1, &hspi4, RTD_CS1_GPIO_Port, RTD_CS1_Pin, 3, 60);
	Max31865_init(&rtd2, &hspi4, RTD_CS2_GPIO_Port, RTD_CS2_Pin, 3, 60);
	Max31865_init(&rtd3, &hspi4, RTD_CS3_GPIO_Port, RTD_CS3_Pin, 3, 60);
}

void RTD_Update_All(void)
{
	static uint32_t last = 0;
	if (HAL_GetTick() - last < 500)
		return;
	last = HAL_GetTick();

	Max31865_readTempC(&rtd1, (float*) &g_t1);
	Max31865_readTempC(&rtd2, (float*) &g_t2);
	Max31865_readTempC(&rtd3, (float*) &g_t3);
}

// ���� �쟾�븬 蹂��솚 �븿�닔
static inline uint16_t volts_to_d12(float vout, float vref, int gain_x2)
{
	if (vout < 0)
		vout = 0;
	if (gain_x2)
		vref *= 2.0f;
	float d = (vout / vref) * 4095.0f;
	if (d > 4095.0f)
		d = 4095.0f;
	return (uint16_t) (d + 0.5f);
}

void SENSOR_FreqTask(void)
{
	static uint32_t last_ms = 0;
	uint32_t now = HAL_GetTick();

	if ((now - last_ms) >= FAN_RPM_PERIOD_MS)
	{
		last_ms = now;

		float dt = (float) FAN_RPM_PERIOD_MS / 1000.0f;   //

		// FAN PulseCount
		uint32_t fan_p = g_fan_pulse_count;
		g_fan_pulse_count = 0;

		if (fan_p > 0)
		{
			float fan_freq = ((float) fan_p) / dt;   // Hz
			// PWM_FAN_RPM = fan_freq;
			PWM_FAN_RPM = (fan_freq * 60.0f) / FAN_PULSES_PER_REV;
		}
		else
		{
			PWM_FAN_RPM = 0.0f;
		}

		// Pump PulseCount
		uint32_t pump_p = g_pump_pulse_count;
		g_pump_pulse_count = 0;

		if (pump_p > 0)
		{
			float pump_freq = ((float) pump_p) / dt;   // Hz
			TANK_ADD_PUMP_FREQ = pump_freq;           // Hz 洹몃�濡� ���옣
		}
		else
		{
			TANK_ADD_PUMP_FREQ = 0.0f;
		}
	}
}

void EEPROM_Test(void)
{
	uint8_t wbuf[8] =
	{ 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88 };
	uint8_t rbuf[8] =
	{ 0 };

	// 0x0000 踰덉��뿉 8諛붿씠�듃 �벐湲�
	HAL_StatusTypeDef ret;
	ret = Write_24Cxx(0x0000, wbuf, sizeof(wbuf));
	if (ret != HAL_OK)
	{
		// �뿉�윭 �몴�떆: LED 源쒕묀�씠嫄곕굹, 紐⑤뱶踰꾩뒪�뿉 �뵆�옒洹� �삱由ш굅�굹
		OUTCTL_On(OUT_LED1);
		return;
	}
	HAL_Delay(5);   // write cycle

	// �떎�떆 �씫湲�
	ret = Read_24Cxx(0x0000, rbuf, sizeof(rbuf));
	if (ret != HAL_OK)
	{
		OUTCTL_On(OUT_LED2);
		return;
	}

	Modbus_SetHoldingRegister(&modbus, 60, (rbuf[0] << 8) | rbuf[1]);
}

// ���� Modbus Coil 16 �넂 �뙩 PWM Enable ��������������������������������������������������
void FAN_Update_EnableFromCoil(Modbus_t *mb)
{
	static uint8_t prev_en = 0xFF;

	uint8_t en = Modbus_GetCoil(mb, MB_COIL_FAN_PWM_EN);

	if (en == prev_en)
	{
		return;    // 蹂��솕 �뾾�쑝硫� �븘臾닿쾬�룄 �븞 �븿
	}
	prev_en = en;

	if (en)
	{
		// PWM �떆�옉
		HAL_TIM_PWM_Start(&htim1, TIM_CHANNEL_2);
	}
	else
	{
		// PWM �젙吏� + 媛뺤젣 LOW(�븞�쟾�븯寃�)
		HAL_TIM_PWM_Stop(&htim1, TIM_CHANNEL_2);
		__HAL_TIM_SET_COMPARE(&htim1, TIM_CHANNEL_2, 0);
	}
}

/* USER CODE END 0 */

/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{

	/* USER CODE BEGIN 1 */

	/* USER CODE END 1 */

	/* MCU Configuration--------------------------------------------------------*/

	/* Reset of all peripherals, Initializes the Flash interface and the Systick. */
	HAL_Init();

	/* USER CODE BEGIN Init */

	/* USER CODE END Init */

	/* Configure the system clock */
	SystemClock_Config();

	/* USER CODE BEGIN SysInit */

	/* USER CODE END SysInit */

	/* Initialize all configured peripherals */
	MX_GPIO_Init();
	MX_DMA_Init();
	MX_ADC1_Init();
	MX_ADC3_Init();
	MX_I2C1_Init();
	MX_SPI4_Init();
	MX_TIM1_Init();
	MX_TIM3_Init();
	MX_USART1_UART_Init();
	MX_USART3_UART_Init();
	MX_USART6_UART_Init();
	MX_TIM5_Init();
	MX_ADC2_Init();
	MX_RTC_Init();
	MX_SPI5_Init();
	MX_TIM10_Init();
	MX_SPI2_Init();
	/* USER CODE BEGIN 2 */

	HAL_GPIO_WritePin(ESP32_EN_GPIO_Port, ESP32_EN_Pin, GPIO_PIN_RESET);
	HAL_Delay(1000);
	HAL_GPIO_WritePin(ESP32_EN_GPIO_Port, ESP32_EN_Pin, GPIO_PIN_SET);
	// Modbus_Init(&modbus, &huart3, 1);  // slave ID 1踰� MASTER �슜
	Modbus_Init(&modbus, &huart6, 1);  // slave ID 1踰� SLAVE �슜

	// RTC_SetDefaultIfNeeded();
	//RTC_ForceSetTest();
//  FAN_SetPWM(0, 0);
	// Enable TIM IC interrupts
	HAL_TIM_IC_Start_IT(&htim1, TIM_CHANNEL_1); // �뙩 RPM
	HAL_TIM_IC_Start_IT(&htim5, TIM_CHANNEL_3); // �럩�봽 二쇳뙆�닔

	HAL_NVIC_SetPriority(USART1_IRQn, 5, 0);
	HAL_NVIC_EnableIRQ(USART1_IRQn);

	// 泥� �닔�떊 ��湲� �떆�옉(2諛붿씠�듃 猷⑦봽諛� �봽�젅�엫)
	HXB2_CMD_Init();
	HAL_UART_Receive_IT(&huart1, g_uart1_rx, 1);

	ads_hw_init_pins_idle();
	ads_clkin_start();
	uint16_t clock_val = 0;

	// 1) 현재 CLOCK 레지스터 값을 먼저 읽어옵니다. (다른 비트 유지 목적)
	HAL_StatusTypeDef st = ads_read_reg(ADS131M04_REG_CLOCK, &clock_val);
	if (st != HAL_OK)
		return st;

	// 2) 기존 OSR 비트 자리를 0으로 비워줍니다.
	clock_val &= ~ADS_OSR_MASK;

	// 3) 원하는 OSR 값을 채워 넣습니다. (여기서는 최대치인 16384 적용)
	clock_val |= ADS_OSR_16384;

	// 4) 방금 만든 함수를 호출하여 씁니다.
	bool verify_ok = false;
	st = ads_write_reg(ADS131M04_REG_CLOCK, clock_val, &verify_ok);

	// --------------------------------------------------------
	// CFG 레지스터 설정: Global Chop 켜기 + Delay 넉넉하게 주기
	// --------------------------------------------------------
	// GC_EN (Bit 8) = 1 (Global Chop 활성화)
	// GC_DLY (Bit 12:9) = 1001 (9) -> 4096 Modulator clocks 대기
	// 나머지 비트는 디폴트(0) 유지
	// 계산: (9 << 9) | (1 << 8) = 0x1200 | 0x0100 = 0x1300

	uint16_t cfg_val = ((1 << 9) | (1 << 8));

	st = ads_write_reg(ADS131M04_REG_CFG, cfg_val, &verify_ok);
	HAL_Delay(300);

	EEPROM_Test();
	//ADC Init

	//DAC Init
	DAC8554_Init();

	// 0으로 초기화
	(void) DAC8554_WriteUpdate(DAC8554_CH_A, 0);
	(void) DAC8554_WriteUpdate(DAC8554_CH_B, 0);
	(void) DAC8554_WriteUpdate(DAC8554_CH_C, 0);
	(void) DAC8554_WriteUpdate(DAC8554_CH_D, 0);

	HAL_Delay(200);
	/* USER CODE END 2 */

	/* Init scheduler */
	osKernelInitialize();

	/* Call init function for freertos objects (in cmsis_os2.c) */
	MX_FREERTOS_Init();

	/* Start scheduler */
	osKernelStart();

	/* We should never get here as control is now taken by the scheduler */

	/* Infinite loop */
	/* USER CODE BEGIN WHILE */

	//System_Logic_Init();
	while (1)
	{
		//	Modbus_Process(&modbus);
		//	RTD_Update_All();
		//	ADC_APP_Poll();
		//	WS2812_Update_FromHolding(&modbus);
		//	Modbus_Update_TempValues();

		//	Modbus_Update_ADC_Registers();
		//	Modbus_Update_RPM_Regs();
		/* USER CODE END WHILE */

		/* USER CODE BEGIN 3 */
	}
	/* USER CODE END 3 */
}

/**
 * @brief System Clock Configuration
 * @retval None
 */
void SystemClock_Config(void)
{
	RCC_OscInitTypeDef RCC_OscInitStruct =
	{ 0 };
	RCC_ClkInitTypeDef RCC_ClkInitStruct =
	{ 0 };

	/** Configure the main internal regulator output voltage
	 */
	__HAL_RCC_PWR_CLK_ENABLE();
	__HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

	/** Initializes the RCC Oscillators according to the specified parameters
	 * in the RCC_OscInitTypeDef structure.
	 */
	RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE
			| RCC_OSCILLATORTYPE_LSE;
	RCC_OscInitStruct.HSEState = RCC_HSE_ON;
	RCC_OscInitStruct.LSEState = RCC_LSE_ON;
	RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
	RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
	RCC_OscInitStruct.PLL.PLLM = 15;
	RCC_OscInitStruct.PLL.PLLN = 216;
	RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
	RCC_OscInitStruct.PLL.PLLQ = 4;
	if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
	{
		Error_Handler();
	}

	/** Activate the Over-Drive mode
	 */
	if (HAL_PWREx_EnableOverDrive() != HAL_OK)
	{
		Error_Handler();
	}

	/** Initializes the CPU, AHB and APB buses clocks
	 */
	RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_SYSCLK
			| RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2;
	RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
	RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
	RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
	RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;

	if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5) != HAL_OK)
	{
		Error_Handler();
	}
}

/* USER CODE BEGIN 4 */
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{
	// Modbus UART 泥섎━ (UART3, UART6)
	if (huart == &huart3 || huart == &huart6)
	{
		Modbus_UARTRxCallback(&modbus, huart);
		return;
	}

	// UART1 Loopback / Test RX 泥섎━
	if (huart == &huart1)
	{
		HXB2_CMD_OnRxByte(g_uart1_rx[0]);

		// 다음 바이트 계속 받기
		HAL_UART_Receive_IT(huart, g_uart1_rx, 1);
		return;
	}
}

void HAL_UART_TxCpltCallback(UART_HandleTypeDef *huart)
{
	Modbus_UARTTxCallback(&modbus, huart);
}

void HAL_UART_IdleCallback(UART_HandleTypeDef *huart)
{
	Modbus_UARTIdleCallback(&modbus, huart);
}

void HAL_TIM_IC_CaptureCallback(TIM_HandleTypeDef *htim)
{
	// ���� FAN RPM : TIM1 CH1 ��������������������������������������������������������������
	if (htim->Instance == TIM1 && htim->Channel == HAL_TIM_ACTIVE_CHANNEL_1)
	{
		g_fan_pulse_count++;
		return;
	}

	// ���� PUMP FREQ : TIM5 CH3 ����������������������������������������������������������
	if (htim->Instance == TIM5 && htim->Channel == HAL_TIM_ACTIVE_CHANNEL_3)
	{
		g_pump_pulse_count++;
		return;
	}
}
extern osThreadId_t taskReadADCHandle;
void HAL_GPIO_EXTI_Callback(uint16_t GPIO_Pin)
{
	if (GPIO_Pin == GPIO_PIN_9)
	{
		if (taskReadADCHandle != NULL)
		{
			BaseType_t hpw = pdFALSE;
			vTaskNotifyGiveFromISR(taskReadADCHandle, &hpw);
			portYIELD_FROM_ISR(hpw);
		}
	}
}
/* USER CODE END 4 */

/**
 * @brief  Period elapsed callback in non blocking mode
 * @note   This function is called  when TIM14 interrupt took place, inside
 * HAL_TIM_IRQHandler(). It makes a direct call to HAL_IncTick() to increment
 * a global variable "uwTick" used as application time base.
 * @param  htim : TIM handle
 * @retval None
 */
void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{
	/* USER CODE BEGIN Callback 0 */

	/* USER CODE END Callback 0 */
	if (htim->Instance == TIM14)
	{
		HAL_IncTick();
	}
	/* USER CODE BEGIN Callback 1 */

	/* USER CODE END Callback 1 */
}

/**
 * @brief  This function is executed in case of error occurrence.
 * @retval None
 */
void Error_Handler(void)
{
	/* USER CODE BEGIN Error_Handler_Debug */
	/* User can add his own implementation to report the HAL error return state */

	/* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
