/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * File Name          : freertos.c
 * Description        : Code for freertos applications
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2025 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "FreeRTOS.h"
#include "task.h"
#include "main.h"
#include "cmsis_os.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "Baremetal_Tasks.h"
#include "dac8554.h"
#include "ads131m04.h"
#include "spi.h"
#include "queue.h"
#include <math.h>
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN Variables */
extern QueueHandle_t s_q;
extern TaskHandle_t s_task;
/* USER CODE END Variables */
/* Definitions for defaultTask */
osThreadId_t defaultTaskHandle;
const osThreadAttr_t defaultTask_attributes =
{ .name = "defaultTask", .stack_size = 8192 * 4, .priority =
		(osPriority_t) osPriorityNormal, };
/* Definitions for taskA */
osThreadId_t taskAHandle;
const osThreadAttr_t taskA_attributes =
{ .name = "taskA", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskB */
osThreadId_t taskBHandle;
const osThreadAttr_t taskB_attributes =
{ .name = "taskB", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskC */
osThreadId_t taskCHandle;
const osThreadAttr_t taskC_attributes =
{ .name = "taskC", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskD */
osThreadId_t taskDHandle;
const osThreadAttr_t taskD_attributes =
{ .name = "taskD", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskE */
osThreadId_t taskEHandle;
const osThreadAttr_t taskE_attributes =
{ .name = "taskE", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskF */
osThreadId_t taskFHandle;
const osThreadAttr_t taskF_attributes =
{ .name = "taskF", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskDAC */
osThreadId_t taskDACHandle;
const osThreadAttr_t taskDAC_attributes =
{ .name = "taskDAC", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskL */
osThreadId_t taskLHandle;
const osThreadAttr_t taskL_attributes =
{ .name = "taskL", .stack_size = 384 * 4, .priority =
		(osPriority_t) osPriorityLow, };
/* Definitions for taskReadADC */
osThreadId_t taskReadADCHandle;
const osThreadAttr_t taskReadADC_attributes =
{ .name = "taskReadADC", .stack_size = 512 * 4, .priority =
		(osPriority_t) osPriorityLow, };

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN FunctionPrototypes */

/* USER CODE END FunctionPrototypes */

void StartDefaultTask(void *argument);
void startTaskA(void *argument);
void startTaskB(void *argument);
void startTaskC(void *argument);
void startTaskD(void *argument);
void startTaskE(void *argument);
void startTaskF(void *argument);
void startTaskDAC(void *argument);
void startTaskL(void *argument);
void startTaskReadADC(void *argument);

void MX_FREERTOS_Init(void); /* (MISRA C 2004 rule 8.1) */

/**
 * @brief  FreeRTOS initialization
 * @param  None
 * @retval None
 */
void MX_FREERTOS_Init(void)
{
	/* USER CODE BEGIN Init */

	/* USER CODE END Init */

	/* USER CODE BEGIN RTOS_MUTEX */
	/* add mutexes, ... */
	/* USER CODE END RTOS_MUTEX */

	/* USER CODE BEGIN RTOS_SEMAPHORES */
	/* add semaphores, ... */
	/* USER CODE END RTOS_SEMAPHORES */

	/* USER CODE BEGIN RTOS_TIMERS */
	/* start timers, add new ones, ... */
	/* USER CODE END RTOS_TIMERS */

	/* USER CODE BEGIN RTOS_QUEUES */
	/* add queues, ... */
	/* USER CODE END RTOS_QUEUES */

	/* Create the thread(s) */
	/* creation of defaultTask */
	defaultTaskHandle = osThreadNew(StartDefaultTask, NULL,
			&defaultTask_attributes);

	/* creation of taskA */
	taskAHandle = osThreadNew(startTaskA, NULL, &taskA_attributes);

	/* creation of taskB */
	taskBHandle = osThreadNew(startTaskB, NULL, &taskB_attributes);

	/* creation of taskC */
	taskCHandle = osThreadNew(startTaskC, NULL, &taskC_attributes);

	/* creation of taskD */
	taskDHandle = osThreadNew(startTaskD, NULL, &taskD_attributes);

	/* creation of taskE */
	taskEHandle = osThreadNew(startTaskE, NULL, &taskE_attributes);

	/* creation of taskF */
	taskFHandle = osThreadNew(startTaskF, NULL, &taskF_attributes);

	/* creation of taskDAC */
	taskDACHandle = osThreadNew(startTaskDAC, NULL, &taskDAC_attributes);

	/* creation of taskL */
	taskLHandle = osThreadNew(startTaskL, NULL, &taskL_attributes);

	/* creation of taskReadADC */
	taskReadADCHandle = osThreadNew(startTaskReadADC, NULL,
			&taskReadADC_attributes);

	/* USER CODE BEGIN RTOS_THREADS */
	/* add threads, ... */
	s_task = taskDACHandle;
	/* USER CODE END RTOS_THREADS */

	/* USER CODE BEGIN RTOS_EVENTS */
	/* add events, ... */
	/* USER CODE END RTOS_EVENTS */

}

/* USER CODE BEGIN Header_StartDefaultTask */
/**
 * @brief  Function implementing the defaultTask thread.
 * @param  argument: Not used
 * @retval None
 */
/* USER CODE END Header_StartDefaultTask */
void StartDefaultTask(void *argument)
{
	/* USER CODE BEGIN StartDefaultTask */
	OUTCTL_Init();
	System_Logic_Init();
	DAC_TaskInit();

	rtd_init_all();
	ADC_APP_Start();
	ws2812Init();
	for (;;)
	{
		ESP32_Telemetry_Task_1Hz();
		/*if (now - shared_cache.last_sync_time > 3000)
		 {
		 shared_cache.time_sync_ok = false;
		 shared_cache.is_emergency = true; // 통신 두절 시 비상 정지
		 }
		 else
		 {
		 shared_cache.time_sync_ok = true;
		 }*/

		// 2. 비상 정지 시 안전 조치
		if (shared_cache.is_emergency)
		{
			shared_cache.psu_enable = false;
			shared_cache.electrolyte_enable = false;

			// 즉시 하드웨어 차단
			//mcp4728_Write_All_Channels(0, 0, 0, 0);
			//MCP4728_Write_AllChannels_Same(&hi2c3, 0);
			DAC_SetCodesSimul(0, 0, 0, 0, 5);
			//All_Valves_Off();
		}
		osDelay(1000);
		;
	}
	/* USER CODE END StartDefaultTask */
}

/* USER CODE BEGIN Header_startTaskA */
/**
 * @brief Function implementing the taskA thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskA */
void startTaskA(void *argument)
{
	/* USER CODE BEGIN startTaskA */
	/* Infinite loop */
	for (;;)
	{
		Task_A_Sensors();
		osDelay(10);
	}
	/* USER CODE END startTaskA */
}

/* USER CODE BEGIN Header_startTaskB */
/**
 * @brief Function implementing the taskB thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskB */
void startTaskB(void *argument)
{
	/* USER CODE BEGIN startTaskB */
	/* Infinite loop */
	for (;;)
	{
		Task_B_Refill();
		osDelay(500);
	}
	/* USER CODE END startTaskB */
}

/* USER CODE BEGIN Header_startTaskC */
/**
 * @brief Function implementing the taskC thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskC */
void startTaskC(void *argument)
{
	/* USER CODE BEGIN startTaskC */
	/* Infinite loop */
	for (;;)
	{
		Task_C_Circulation();
		osDelay(1);
	}
	/* USER CODE END startTaskC */
}

/* USER CODE BEGIN Header_startTaskD */
/**
 * @brief Function implementing the taskD thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskD */
void startTaskD(void *argument)
{
	/* USER CODE BEGIN startTaskD */
	/* Infinite loop */
	for (;;)
	{
		Task_D_TempControl();
		osDelay(10);
	}
	/* USER CODE END startTaskD */
}

/* USER CODE BEGIN Header_startTaskE */
/**
 * @brief Function implementing the taskE thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskE */
void startTaskE(void *argument)
{
	/* USER CODE BEGIN startTaskE */
	/* Infinite loop */
	for (;;)
	{
		Task_E_PSU();
		osDelay(1);
	}
	/* USER CODE END startTaskE */
}

/* USER CODE BEGIN Header_startTaskF */
/**
 * @brief Function implementing the taskF thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskF */
void startTaskF(void *argument)
{
	/* USER CODE BEGIN startTaskF */
	/* Infinite loop */
	for (;;)
	{
		Task_F_ApplyValveMode();
		osDelay(10);
	}
	/* USER CODE END startTaskF */
}

/* USER CODE BEGIN Header_startTaskDAC */
/**
 * @brief Function implementing the taskDAC thread.
 * @param argument: Not used
 * @retval None
 */

/* USER CODE END Header_startTaskDAC */
void startTaskDAC(void *argument)
{
	/* USER CODE BEGIN startTaskDAC */
	/* Infinite loop */
	(void) argument;

	dac_svc_req_t r;

	for (;;)
	{
		if (s_q == NULL)
		{
			vTaskDelay(pdMS_TO_TICKS(50));
			continue;
		}

		if (xQueueReceive(s_q, &r, portMAX_DELAY) != pdTRUE)
		{
			continue;
		}

		HAL_StatusTypeDef st = HAL_ERROR;

		switch (r.type)
		{
		case DAC_SVC_REQ_WRITE_UPDATE:
			st = DAC8554_WriteUpdate(map_ch(r.ch), r.code16);
			break;

		case DAC_SVC_REQ_WRITE_BUFFER:
			st = DAC8554_WriteBuffer(map_ch(r.ch), r.code16);
			break;

		case DAC_SVC_REQ_TRIGGER_LDAC:
			st = DAC8554_TriggerLDAC();
			break;

		case DAC_SVC_REQ_POWERDOWN:
			st = DAC8554_PowerDown(map_ch(r.ch), (dac8554_pdmode_t) r.pd_mode,
					r.load_now);
			break;

		default:
			st = HAL_ERROR;
			break;
		}

		if (r.caller)
		{
			xTaskNotify(r.caller, (uint32_t )st, eSetValueWithOverwrite);
		}
	}
	/* USER CODE END startTaskDAC */
}

/* USER CODE BEGIN Header_startTaskL */
/**
 * @brief Function implementing the taskL thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskL */
void startTaskL(void *argument)
{
	/* USER CODE BEGIN startTaskL */
	/* Infinite loop */
	for (;;)
	{
		Task_L_UpdateLEDs();
		osDelay(50);
	}
	/* USER CODE END startTaskL */
}

/* USER CODE BEGIN Header_startTaskReadADC */
// -------- ADC 상수 --------
#define FS_23      (8388607.0f)
#define VREF_ADC   (1.2f)
#define R_SHUNT    (51.0f)

// CH mapping
#define CH_VOLT_SEN     0
#define CH_CURR_SEN     1
#define CH_GAS_P_SEN1   2
#define CH_GAS_P_SEN2   3

// -------- 필터 튜닝 --------
#define EXTADC_TAU_S        (0.20f)
#define EXTADC_NOTIFY_TO_MS (200)

// ============================================================
// 고정 오프셋(코드 단위) — 여기만 네가 실측치로 채우면 됨
//  - 4-20mA 채널: 4mA 안정상태 raw 평균값을 기반으로 오프셋 산출 추천
//  - HASS 채널  : 0A 안정상태 raw 평균값을 그대로 오프셋으로
// ============================================================

// (참고) 4mA 이론 코드(51Ω, Vref=1.2): 약 1,426,063
#define CODE_4MA_IDEAL      (1426063)

// ============================================================
// 전압 센서 RAW -> 이상적 RAW 변환 2-Point 캘리브레이션 계수
// ============================================================
#define VOLT_GAIN_A   (0.0000092978f)
#define VOLT_OFFSET_B (-13.57960f)

// ============================================================

#define OFFSET_CODE_VOLT (0)
#define OFFSET_CODE_GAS1    (-59146)
#define OFFSET_CODE_GAS2    (-59146)

// HASS-50S: 0A에서 측정된 raw 평균(예: +12345면 OFFSET=12345)
#define OFFSET_CODE_CURR    (-13190)

static inline float code_to_Voltage_calibrated(int32_t code_raw_filt)
{
    return ((float)code_raw_filt * VOLT_GAIN_A) + VOLT_OFFSET_B;
}

static inline int32_t round_and_clamp_code(double y)
{
	// double 정밀도로 반올림 수행
	int32_t v = (int32_t) (y >= 0.0 ? (y + 0.5) : (y - 0.5));
	return clamp_code_24s(v);
}

// τ 기반 exp filter (64비트 double 적용)
typedef struct
{
	double y;
	uint8_t init;
} exp_filt_code_t;

static inline double exp_filt_code_update_tau(exp_filt_code_t *f, double x,
		float dt_s, float tau_s)
{
	if (!f->init)
	{
		f->y = x;
		f->init = 1;
		return x;
	}
	if (tau_s <= 0.0f)
	{
		f->y = x;
		return x;
	}

	// a 값 계산식:
	// $$ a = 1 - e^{-\frac{dt}{\tau}} $$
	// 미세한 a 값과 거대한 x 값의 곱셈에서 오차를 없애기 위해 double 사용
	double a = 1.0 - exp(-(double) dt_s / (double) tau_s);
	f->y += a * (x - f->y);
	return f->y;
}

// -------- 물리량 변환 (필터된 보정 RAW 기준) --------
static inline double code_to_mA_4_20(int32_t code_filt)
{
	double v = ((double) code_filt / FS_23) * VREF_ADC;
	return (v / R_SHUNT) * 1000.0f;
}

// HASS-50S + INA Gain=1(Rg 미삽): I(A)=code/FS * 96
static inline double code_to_A_hass50s(int32_t code_filt)
{
	return ((double) code_filt / FS_23) * 96.0f;
}
/**
 * @brief Function implementing the taskReadADC thread.
 * @param argument: Not used
 * @retval None
 */
/* USER CODE END Header_startTaskReadADC */
void startTaskReadADC(void *argument)
{
	/* USER CODE BEGIN startTaskReadADC */
	exp_filt_code_t fv =
	{ 0 }, fi =
	{ 0 }, fg1 =
	{ 0 }, fg2 =
	{ 0 };
	TickType_t last_tick = xTaskGetTickCount();

	// ADC 초기 기동 시 불안정한 값을 무시하기 위한 웜업 카운터
	uint8_t warmup_count = 10;

	for (;;)
	{
		uint32_t n = ulTaskNotifyTake(pdTRUE,
				pdMS_TO_TICKS(EXTADC_NOTIFY_TO_MS));
		if (n == 0)
			continue;

		TickType_t now = xTaskGetTickCount();
		float dt_s = ticks_to_sec(now - last_tick);
		if (dt_s <= 0.0f)
			dt_s = 0.001f;
		last_tick = now;

		int32_t ch[4];
		if (ads_read_channels(ch) != HAL_OK)
			continue;

		// --- 초기 불안정 데이터 무시 (Warm-up) ---
		if (warmup_count > 0)
		{
			warmup_count--;
			continue; // 필터 초기화 및 데이터 갱신을 건너뜀
		}

		// 1) 원본 RAW 저장
		shared_cache.volt_sen_raw = ch[CH_VOLT_SEN];
		shared_cache.curr_sen_raw = ch[CH_CURR_SEN];
		shared_cache.h_gas_p_sen1_raw = ch[CH_GAS_P_SEN1];
		shared_cache.h_gas_p_sen2_raw = ch[CH_GAS_P_SEN2];

		// 2) 고정 오프셋 적용 -> 보정 RAW
		int32_t v_cal = clamp_code_24s(ch[CH_VOLT_SEN] - OFFSET_CODE_VOLT);
		int32_t i_cal = clamp_code_24s(ch[CH_CURR_SEN] - OFFSET_CODE_CURR);
		int32_t g1_cal = clamp_code_24s(ch[CH_GAS_P_SEN1] - OFFSET_CODE_GAS1);
		int32_t g2_cal = clamp_code_24s(ch[CH_GAS_P_SEN2] - OFFSET_CODE_GAS2);

		shared_cache.volt_sen_raw_cal = v_cal;
		shared_cache.curr_sen_raw_cal = i_cal;
		shared_cache.h_gas_p_sen1_raw_cal = g1_cal;
		shared_cache.h_gas_p_sen2_raw_cal = g2_cal;

		// 3) 보정 RAW에 exp filter -> double 형으로 정밀하게 계산
		double v_f = exp_filt_code_update_tau(&fv, (double) v_cal, dt_s,
				EXTADC_TAU_S);
		double i_f = exp_filt_code_update_tau(&fi, (double) i_cal, dt_s,
				EXTADC_TAU_S);
		double g1_f = exp_filt_code_update_tau(&fg1, (double) g1_cal, dt_s,
				EXTADC_TAU_S);
		double g2_f = exp_filt_code_update_tau(&fg2, (double) g2_cal, dt_s,
				EXTADC_TAU_S);

		// 정수로 반올림
		int32_t v_filt = round_and_clamp_code(v_f);
		int32_t i_filt = round_and_clamp_code(i_f);
		int32_t g1_filt = round_and_clamp_code(g1_f);
		int32_t g2_filt = round_and_clamp_code(g2_f);

		// ESP32로 보낼 값: raw_filt
		shared_cache.volt_sen_raw_filt = v_filt;
		shared_cache.curr_sen_raw_filt = i_filt;
		shared_cache.h_gas_p_sen1_raw_filt = g1_filt;
		shared_cache.h_gas_p_sen2_raw_filt = g2_filt;

		// 4) 물리량 변환 (필터링된 결과 기준)
		shared_cache.volt_sen_mA = code_to_mA_4_20(v_filt);
		shared_cache.h_gas_p_sen1_mA = code_to_mA_4_20(g1_filt);
		shared_cache.h_gas_p_sen2_mA = code_to_mA_4_20(g2_filt);
		shared_cache.curr_sen_A = code_to_A_hass50s(i_filt);
	}
	/* USER CODE END startTaskReadADC */
}

/* Private application code --------------------------------------------------*/
/* USER CODE BEGIN Application */

/* USER CODE END Application */

