#pragma once
#include "main.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

// === ioc 라벨 기반 출력 채널 식별자 ===
// (TR로 24V 부하를 구동하는 후보 + 일반 DO/LED 포함)
typedef enum {
  OUT_CARTRIDGE_HEATER = 0, // PH2
  OUT_H_GAS_SOL3,           // PH3
  OUT_H_GAS_SOL2,           // PH4
  OUT_H_GAS_SOL1,           // PH5
  OUT_DC_FAN,               // PE7
  OUT_EXT_FAN1,             // PA8
  OUT_EXT_FAN2,             // PC9
  OUT_PSU_ON,               // PF0
  OUT_ELEC_CONTACT,         // PF2
  OUT_SPARE_DO1,            // PG2
  OUT_SPARE_DO2,            // PD15
  OUT_SPARE_DO3,            // PD14
  OUT_LED1,                 // PG6
  OUT_LED2,                 // PG7
  OUT_LED3,                 // PG8

  OUT_COUNT
} OutChannel;

#define MB_COIL_FAN_PWM_EN   OUT_COUNT   // OUT_COUNT = 16 → Coil 16

// 초기화(모든 채널 Safe 상태로)
void OUTCTL_Init(void);

// 온/오프/토글
void OUTCTL_On(OutChannel ch);
void OUTCTL_Off(OutChannel ch);
void OUTCTL_Toggle(OutChannel ch);

// 펄스/블링크 헬퍼
void OUTCTL_Pulse(OutChannel ch, uint32_t ms);   // 블로킹 펄스
void OUTCTL_BlinkAll(uint32_t period_ms);        // 주기적 토글(주기마다 호출)

#ifdef __cplusplus
}
#endif
