/*
 * hxb2_cmd_stm32.h
 *
 *  Created on: Dec 3, 2025
 *      Author: c6h6
 */
/*
 * hxb2_cmd_stm32.h
 *
 *  Created on: Dec 3, 2025
 *      Author: c6h6
 */

#ifndef HXB2_CMD_STM32_H
#define HXB2_CMD_STM32_H

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

/* HMI/ESP32 → STM32 ASCII command protocol
 *
 *  - TIME,YYYY-MM-DD,HH:MM:SS\r\n
 *  - CMD,<rev>,<psu48>,<elec_ena>,<highp_ena>,<psu48_v>,<psu48_i>,<t_sp>,<flow_sp>\r\n
 *  - EMG,<value>\r\n
 */

typedef struct
{
	uint32_t tick_lastbytereceived;
    uint16_t cmd_rev;
    bool     cmd_rev_valid;

    /* Digital outputs (HMI → STM32) */
    bool psu48_ena;
    bool psu48_ena_valid;

    bool electrolyte_ctrl_ena;
    bool electrolyte_ctrl_ena_valid;

    bool highp_production_ena;
    bool highp_production_ena_valid;

    /* Analog setpoints */
    double psu48_v_set;
    bool  psu48_v_set_valid;

    double psu48_i_set;
    bool  psu48_i_set_valid;

    float electrolyte_t_sp_degC;
    bool  electrolyte_t_sp_valid;

    float electrolyte_flow_sp_slm;
    bool  electrolyte_flow_sp_valid;

    /* Time sync (TIME command) */
    uint16_t time_year;
    uint8_t  time_month;
    uint8_t  time_day;
    uint8_t  time_hour;
    uint8_t  time_minute;
    uint8_t  time_second;
    bool     time_valid;

    /* Emergency 상태 (latched) */
    bool emergency_stop_latched;

} hxb2_cmd_state_t;

/* UART IRQ에서 한 바이트 수신할 때 임시 저장해 쓰고 싶으면 사용 */
extern uint8_t g_rx_byte;
extern hxb2_cmd_state_t g_hxb2_cmd_state;
/* 초기화: 상태 포인터를 등록하고 내부 FSM 리셋 */
void HXB2_CMD_Init();

/* UART에서 1바이트 수신할 때마다 호출해주면 됨 */
void HXB2_CMD_OnRxByte(uint8_t byte);

/* 필요하면 어플리케이션에서 상태를 가져다 쓰기 쉽게 포인터 반환 */
hxb2_cmd_state_t *HXB2_CMD_GetState(void);

void HXB2_ApplyTimeToRTC(void);

#ifdef __cplusplus
}
#endif

#endif /* HXB2_CMD_STM32_H */
