/*
 * ws2812.h
 *
 *  Created on: 2023. 10. 25.
 *      Author: admin
 */

#ifndef WS2812_H_
#define WS2812_H_
#include "stdbool.h"
#include "string.h"

  #define WS2812_BLUE          0x0000FF
  #define WS2812_GREEN         0x00FF00
  #define WS2812_RED           0xFF0000
  #define WS2812_CYAN          0x00FFFF
  #define WS2812_MAGENTA       0xFF00FF
  #define WS2812_YELLOW        0xFFFF00
  #define WS2812_LIGHTBLUE     0x8080FF
  #define WS2812_LIGHTGREEN    0x80FF80
  #define WS2812_LIGHTRED      0xFF8080
  #define WS2812_LIGHTCYAN     0x80FFFF
  #define WS2812_LIGHTMAGENTA  0xFF80FF
  #define WS2812_LIGHTYELLOW   0xFFFF80
  #define WS2812_DARKBLUE      0x000080
  #define WS2812_DARKGREEN     0x008000
  #define WS2812_DARKDARKGREEN 0x004000
  #define WS2812_DARKRED       0x800000
  #define WS2812_DARKCYAN      0x008080
  #define WS2812_DARKDARKCYAN  0x004040
  #define WS2812_DARKMAGENTA   0x800080
  #define WS2812_DARKYELLOW    0x808000
  #define WS2812_DARKDARKYELLOW    0x101000
  #define WS2812_WHITE         0xFFFFFF
  #define WS2812_LIGHTGRAY     0xD3D3D3
  #define WS2812_GRAY          0x808080
  #define WS2812_DARKGRAY      0x404040
  #define WS2812_BLACK         0x000000
  #define WS2812_BROWN         0xA52A2A
  #define WS2812_ORANGE        0xFFA500
  #define WS2812_TRANSPARENT   0x000000

  #define WS2812_GRAY_3F       0x3F3F3F
  #define WS2812_GRAY_50       0x505050
  #define WS2812_GRAY_55       0x555555
  #define WS2812_GRAY_60       0x606060
  #define WS2812_GRAY_7C       0x7C7C7C
  #define WS2812_GRAY_9A       0x9A9A9A
  #define WS2812_GRAY_AA       0xAAAAAA
  #define WS2812_GRAY_C0       0xC0C0C0
  #define WS2812_GRAY_C8       0xC8C8C8
  #define WS2812_GRAY_D0       0xD0D0D0
  #define WS2812_GRAY_E7       0xE7E7E7
  #define WS2812_BLUE_98       0x000098

#define WS2812_COLOR_EMERGENCY	0xFF0000
#define WS2812_COLOR_STANDBY	0xFFFF00
#define WS2812_COLOR_ELECTROLYTE_CONTROL_ON	0x0073ce
#define WS2812_COLOR_POEWR_CONTROL_ON	0xB51EF0
#define WS2812_COLOR_MAKE_H2 0x00FF15

unsigned char ws2812Init(void);
HAL_StatusTypeDef ws2812Begin(unsigned int led_cnt);
HAL_StatusTypeDef ws2812SetAllColor(unsigned long color);
HAL_StatusTypeDef ws2812SetColor(unsigned long index,unsigned long color);
HAL_StatusTypeDef  ws2812Setpixel(unsigned long index,unsigned char red,unsigned char green,unsigned char blue);
HAL_StatusTypeDef  ws2812Set_one_Color(unsigned long color);

#endif /* WS2812_H_ */
