/*
 * ws2812.c
 *
 *  Created on: 2023. 10. 25.
 *      Author: admin
 */

#include "main.h"
#include "ws2812.h"
#include "string.h"

//#define CNT_PERIOD	90
#define CNT_PERIOD	130

#define BIT_HIGH        CNT_PERIOD/1.85
#define BIT_LOW         CNT_PERIOD/3.71

#define NUM_LED	6

const unsigned char rgb_mask[8] =
{ 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };
unsigned long red, green, blue;

unsigned int led_buf[24 * (NUM_LED + 2)];

extern TIM_HandleTypeDef htim3;

unsigned char ws2812Init(void)
{

	for (int i = 0; i < (NUM_LED); i++)
	{
		for (int j = 0; j < 8; j++)
		{
			led_buf[(i) * 24 + +j] = (BIT_LOW);
			led_buf[(i) * 24 + 8 + j] = (BIT_LOW);
			led_buf[(i) * 24 + 16 + j] = (BIT_LOW);

		}

//		ws2812SetColor(i,0);
//		led_buf[i]=BIT_LOW;
	}

	return 0;
}

HAL_StatusTypeDef ws2812Begin(unsigned int led_cnt)
{
//	HAL_TIM_PWM_Stop_DMA(&htim8, TIM_CHANNEL_4);
	return HAL_TIM_PWM_Start_DMA(&htim3, TIM_CHANNEL_3, (uint32_t*) led_buf,
			24 * (NUM_LED) + 2);
//	return 0;
}
HAL_StatusTypeDef ws2812SetAllColor(unsigned long color)
{
	red = (color >> 16) & 0xff;
	green = (color >> 8) & 0xff;
	blue = (color) & 0xff;
	for (int l = 0; l < NUM_LED; l++)
	{
		for (int i = 0; i < 8; i++)
		{
			led_buf[(l) * 24 + +i] =
					(green & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
			led_buf[(l) * 24 + 8 + i] =
					(red & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
			led_buf[(l) * 24 + 16 + i] =
					(blue & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		}
	}
//	return 0;
	return ws2812Begin(NUM_LED);
}
HAL_StatusTypeDef ws2812SetColor(unsigned long index, unsigned long color)
{
	red = (color >> 16) & 0xff;
	green = (color >> 8) & 0xff;
	blue = (color) & 0xff;
	for (int i = 0; i < 8; i++)
	{
		led_buf[(index) * 24 + +i] =
				(green & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		led_buf[(index) * 24 + 8 + i] =
				(red & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		led_buf[(index) * 24 + 16 + i] =
				(blue & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
	}

//	return 0;
	return ws2812Begin(NUM_LED);
}

HAL_StatusTypeDef ws2812Setpixel(unsigned long index, unsigned char red,
		unsigned char green, unsigned char blue)
{

	for (int i = 0; i < 8; i++)
	{
		led_buf[(index) * 24 + +i] =
				(green & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		led_buf[(index) * 24 + 8 + i] =
				(red & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		led_buf[(index) * 24 + 16 + i] =
				(blue & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
	}
//	return 0;
	return ws2812Begin(NUM_LED);
}

HAL_StatusTypeDef ws2812Set_one_Color(unsigned long color)
{
	red = (color >> 16) & 0xff;
	green = (color >> 8) & 0xff;
	blue = (color) & 0xff;

	for (int i = 0; i < 8; i++)
	{
		for (int j = 0; j < NUM_LED; j++)
		{
			led_buf[(j) * 24 + +i] =
					(green & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
			led_buf[(j) * 24 + 8 + i] =
					(red & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
			led_buf[(j) * 24 + 16 + i] =
					(blue & rgb_mask[i]) ? (BIT_HIGH) : (BIT_LOW);
		}
	}
//	return 0;
	return ws2812Begin(NUM_LED);
}

void HAL_TIM_PWM_PulseFinishedCallback(TIM_HandleTypeDef *htim)
{
	HAL_TIM_PWM_Stop_DMA(&htim3, TIM_CHANNEL_3);
}
