/*
 * ads131m04.h
 *
 *  Created on: Feb 12, 2026
 *      Author: c6h6
 */

#ifndef ADS131M04_H_
#define ADS131M04_H_

#include "FreeRTOS.h"
#include "task.h"
#include <stdint.h>
#include <stdbool.h>
#include "main.h"   // 너 프로젝트 MCU 패밀리에 맞게 변경

// ===========================
// Fixed HW mapping (User)
// ===========================

// 0: CRC OFF (CMD16 + 0x00 padding)
// 1: CRC ON  (CMD16 + CRC16 right after)
#ifndef ADS_USE_CRC
#define ADS_USE_CRC 1
#endif

// CRC init (datasheet에서 init 값 확인되면 여기만 바꾸면 됨)
// 흔한 후보: 0xFFFF 또는 0x0000
#ifndef ADS_CRC_INIT
#define ADS_CRC_INIT 0xFFFFu
#endif

// DRDY wait timeout (ms)
#ifndef ADS_DRDY_TIMEOUT_MS
#define ADS_DRDY_TIMEOUT_MS 100u
#endif


#define ADS_SPI_HANDLE          hspi5
extern SPI_HandleTypeDef ADS_SPI_HANDLE;

#define ADS_CLK_TIM_HANDLE      htim10
extern TIM_HandleTypeDef ADS_CLK_TIM_HANDLE;
#define ADS_CLK_TIM_CHANNEL     TIM_CHANNEL_1   // TIM10_CH1

#define ADS_DRDY_GPIO_PORT      GPIOI
#define ADS_DRDY_GPIO_PIN       GPIO_PIN_9

#define ADS_CS_GPIO_PORT        GPIOI
#define ADS_CS_GPIO_PIN         GPIO_PIN_10

#define ADS_RESET_GPIO_PORT     GPIOI
#define ADS_RESET_GPIO_PIN      GPIO_PIN_11

// ===========================
// Config
// ===========================
#ifndef ADS_SPI_TIMEOUT_MS
#define ADS_SPI_TIMEOUT_MS      10u
#endif

#define ADS_FRAME_BYTES         18u   // 6 words * 24-bit

// ===========================
// Command encoding (CRC OFF)
// 16-bit command packed into the upper 16 bits of the first 24-bit word.
// Format: OPCODE[15:13], ADDR[12:7], COUNTm1[6:0]
// ===========================
#define ADS_CMD_RREG(addr, count) \
    ((uint16_t)((0x5u << 13) | (((uint16_t)(addr) & 0x3Fu) << 7) | (((uint16_t)(count) - 1u) & 0x7Fu)))

#define ADS_CMD_WREG(addr, count) \
    ((uint16_t)((0x3u << 13) | (((uint16_t)(addr) & 0x3Fu) << 7) | (((uint16_t)(count) - 1u) & 0x7Fu)))

// ===========================
// Registers (minimal)
// ===========================
#define ADS131M04_REG_ID            0x00
#define ADS131M04_REG_STATUS        0x01
#define ADS131M04_REG_MODE          0x02
#define ADS131M04_REG_CLOCK         0x03
#define ADS131M04_REG_GAIN1         0x04
#define ADS131M04_REG_CFG           0x06


// OSR 옵션
#define ADS_OSR_1024     (0x03 << 2)  // 기본값 (1024)
#define ADS_OSR_8192     (0x06 << 2)  // 높은 필터링 (8192)
#define ADS_OSR_16384    (0x07 << 2)  // 최대 필터링 (16384)
#define ADS_OSR_MASK     (0x07 << 2)  // Bits 4:2
// ===========================
// API
// ===========================
void ads_hw_init_pins_idle(void);
void ads_reset_pulse(uint32_t delay_ms);

HAL_StatusTypeDef ads_clkin_start(void);
HAL_StatusTypeDef ads_clkin_stop(void);

// Raw frame access (디버깅에 매우 유용)
HAL_StatusTypeDef ads_xfer_frame(uint16_t cmd_word,
                                 const uint8_t *tx_word1_24, // NULL이면 0
                                 uint8_t rx_out[ADS_FRAME_BYTES]);

// 채널 읽기 (NOP 프레임)
HAL_StatusTypeDef ads_read_channels(int32_t ch_out[4]);

// 레지스터 읽기/쓰기 (CRC OFF)
HAL_StatusTypeDef ads_read_reg(uint8_t reg, uint16_t *out);
HAL_StatusTypeDef ads_write_reg(uint8_t reg, uint16_t data, bool *ok);

// 편의 함수
HAL_StatusTypeDef ads_set_gain(uint8_t log2Gain0,
                               uint8_t log2Gain1,
                               uint8_t log2Gain2,
                               uint8_t log2Gain3,
                               bool *ok);

// DRDY 읽기
static inline GPIO_PinState ads_drdy_read(void)
{
    return HAL_GPIO_ReadPin(ADS_DRDY_GPIO_PORT, ADS_DRDY_GPIO_PIN);
}
#endif /* ADS131M04_H_ */
