#include "24LCxx.h"

extern I2C_HandleTypeDef hi2c1;   // ← I2C1 사용

#define EEPROM_I2C    (&hi2c1)
#define EEPROM_ADDR   (0x50 << 1)  // A2~A0=GND 기준, HAL은 7bit<<1

uint8_t i2c_write_buf[10];
uint8_t i2c_read_buf[10];

// 24LC256 : 16bit 워드 주소 사용
HAL_StatusTypeDef Write_24Cxx(uint16_t addr, uint8_t *pData, uint16_t size)
{
    return HAL_I2C_Mem_Write(EEPROM_I2C,
                             EEPROM_ADDR,
                             addr,                     // 16bit 주소
                             I2C_MEMADD_SIZE_16BIT,
                             pData,
                             size,
                             100);
}

HAL_StatusTypeDef Read_24Cxx(uint16_t addr, uint8_t *pData, uint16_t size)
{
    return HAL_I2C_Mem_Read(EEPROM_I2C,
                            EEPROM_ADDR,
                            addr,
                            I2C_MEMADD_SIZE_16BIT,
                            pData,
                            size,
                            100);
}

// int 4바이트 저장/로드 (기존 인터페이스 유지, 주소는 0,1,2,...)
void save_setvalue(uint16_t add, int data)
{
    i2c_write_buf[0] = (data >> 24) & 0xFF;
    i2c_write_buf[1] = (data >> 16) & 0xFF;
    i2c_write_buf[2] = (data >> 8)  & 0xFF;
    i2c_write_buf[3] = (data)       & 0xFF;

    uint16_t mem_addr = add * 4;   // 4바이트 단위로 인덱스
    Write_24Cxx(mem_addr, i2c_write_buf, 4);
    HAL_Delay(5);                  // write cycle 여유 (데이터시트 max 5ms)
}

int load_setvalue(uint16_t add)
{
    uint16_t mem_addr = add * 4;
    Read_24Cxx(mem_addr, i2c_read_buf, 4);
    HAL_Delay(5);

    int v =
        ((int)i2c_read_buf[0] << 24) |
        ((int)i2c_read_buf[1] << 16) |
        ((int)i2c_read_buf[2] << 8)  |
        ((int)i2c_read_buf[3]);
    return v;
}